package com.burhanstore.neonbubblequest.Utils

import android.app.Activity
import android.app.Dialog

import android.graphics.Color
import android.view.Gravity
import android.view.View
import android.view.Window
import android.view.WindowManager
import android.view.animation.AccelerateInterpolator
import android.view.animation.DecelerateInterpolator
import android.widget.LinearLayout
import android.widget.TextView
import android.widget.Toast
import androidx.core.graphics.drawable.toDrawable
import com.burhanstore.neonbubblequest.R
import com.burhanstore.neonbubblequest.Utils.anim.setClick
import com.burhanstore.neonbubblequest.Utils.monetize.RewardAdManager


object DialogManager {

    private var dialog: Dialog? = null
    private var dialog_claim: Dialog? = null

    fun initDialog(activity: Activity) {
        dialog = Dialog(activity).apply {
            setCancelable(false)
            setContentView(R.layout.progress_dialog)
            window?.setBackgroundDrawable(Color.TRANSPARENT.toDrawable())
        }
    }

    fun showDialog() {
        try {
            if (dialog?.isShowing == false) {
                dialog?.show()
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    fun dismissDialog() {
        try {
            if (dialog?.isShowing == true) {
                dialog?.dismiss()
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }

    }

    fun claim_dialog(
        activity: Activity,
        config: String,
        from: String,
        task_id: String,
        coin: String
    ) {

        dialog_claim = Dialog(activity).apply {
            requestWindowFeature(Window.FEATURE_NO_TITLE)
            setContentView(R.layout.claim_dialog)
            setCancelable(true)
            window?.apply {
                setBackgroundDrawable(Color.TRANSPARENT.toDrawable())
                setGravity(Gravity.BOTTOM)
                attributes = attributes?.apply {
                    width = WindowManager.LayoutParams.MATCH_PARENT
                    height = WindowManager.LayoutParams.WRAP_CONTENT
                }
                addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND)
                setDimAmount(0.4f)
            }
        }

        val rootView = dialog_claim?.findViewById<View>(R.id.dialog_root)
        val closeBtn = dialog_claim?.findViewById<LinearLayout>(R.id.closeBtn)
        val claimBtn = dialog_claim?.findViewById<LinearLayout>(R.id.claimBtn)
        val claimText = dialog_claim?.findViewById<TextView>(R.id.claimText)

        claimText?.text = "Claim & Win ${coin} Coins"


        rootView?.apply {
            translationY = 300f
            alpha = 0f
            animate()
                .translationY(0f)
                .alpha(1f)
                .setDuration(400)
                .setInterpolator(DecelerateInterpolator())
                .start()
        }


        //claim
        claimBtn?.setClick {
            Toast.makeText(activity, "Almost there! Loading your ad now.", Toast.LENGTH_SHORT)
                .show()
            RewardAdManager.fallback1(
                activity,
                config,
                from,
                task_id,
                false,
                coin
            )
        }


        // 🔴 Animate dialog closing down
        closeBtn?.setClick {
            rootView?.animate()
                ?.translationY(300f)
                ?.alpha(0f)
                ?.setDuration(300)
                ?.setInterpolator(AccelerateInterpolator())
                ?.withEndAction { dialog_claim?.dismiss() }
                ?.start()
        }

        runCatching {
            dialog_claim?.isShowing?.let { if (!it) dialog_claim?.show() }
        }.onFailure { it.printStackTrace() }


    }


    fun claim_dismissDialog() {
        try {
            if (dialog_claim?.isShowing == true) {
                dialog_claim?.dismiss()
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }



    fun redeem_Success(
        activity: Activity
    ) {

        dialog_claim = Dialog(activity).apply {
            requestWindowFeature(Window.FEATURE_NO_TITLE)
            setContentView(R.layout.redeem_success_dialog)
            setCancelable(true)
            window?.apply {
                setBackgroundDrawable(Color.TRANSPARENT.toDrawable())
                setGravity(Gravity.BOTTOM)
                attributes = attributes?.apply {
                    width = WindowManager.LayoutParams.MATCH_PARENT
                    height = WindowManager.LayoutParams.WRAP_CONTENT
                }
                addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND)
                setDimAmount(0.4f)
            }
        }
        val rootView = dialog_claim?.findViewById<View>(R.id.dialog_root)
        val closeBtn = dialog_claim?.findViewById<LinearLayout>(R.id.closeBtn)
        val claimBtn = dialog_claim?.findViewById<LinearLayout>(R.id.claimBtn)

        rootView?.apply {
            translationY = 300f
            alpha = 0f
            animate()
                .translationY(0f)
                .alpha(1f)
                .setDuration(400)
                .setInterpolator(DecelerateInterpolator())
                .start()
        }

        // close
        claimBtn?.setClick {
            rootView?.animate()
                ?.translationY(300f)
                ?.alpha(0f)
                ?.setDuration(300)
                ?.setInterpolator(AccelerateInterpolator())
                ?.withEndAction { dialog_claim?.dismiss() }
                ?.start()
        }


        // close
        closeBtn?.setClick {
            rootView?.animate()
                ?.translationY(300f)
                ?.alpha(0f)
                ?.setDuration(300)
                ?.setInterpolator(AccelerateInterpolator())
                ?.withEndAction { dialog_claim?.dismiss() }
                ?.start()
        }



        runCatching {
            dialog_claim?.isShowing?.let { if (!it) dialog_claim?.show() }
        }.onFailure { it.printStackTrace() }


    }





}